<?php
require("../includes/header.php");
require_once("../config/connection.php");
?>
<?php
$query = "SELECT * FROM app_settings";
$result = $mysqli->query($query);
$row = $result->fetch_assoc();

$appname = $row['appname'] ?? '';
$purchase_code = $row['purchase_code'] ?? '';
$purchase_source = $row['purchase_source'] ?? '';
$package_name = $row['package_name'] ?? '';
$onesignal_app_id = $row['onesignal_app_id'] ?? '';
$onesignal_rest_api = $row['onesignal_rest_api'] ?? '';

$base_url = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]" . dirname($_SERVER['SCRIPT_NAME']);

$purchase_source_text = "Unknown Source";
if ($purchase_source == 1) {
    $purchase_source_text = "BycomBazaar";
} elseif ($purchase_source == 2) {
    $purchase_source_text = "CodeCanyon";
} elseif ($purchase_source == 3) {
    $purchase_source_text = "Codester";
}

$show_activate_button = true;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $purchase_code   = $_POST['purchase_code']   ?? '';
    $purchase_source = $_POST['purchase_source'] ?? '';
    $package_name    = $_POST['package_name']    ?? '';

    if (isset($_POST['save_data']) || isset($_POST['activate_license'])) {

        if (empty($purchase_code) || empty($purchase_source) || empty($package_name)) {
            $errorMessage = "All fields are required.";
        } else {
            $stmt = $mysqli->prepare("UPDATE app_settings SET purchase_code = ?, purchase_source = ?, package_name = ?");
            $stmt->bind_param("sss", $purchase_code, $purchase_source, $package_name);

            if ($stmt->execute()) {
                $successMessage = isset($_POST['activate_license']) 
                    ? "Activation successful: License validated successfully." 
                    : "Data updated successfully.";
                
                $purchase_code   = $_POST['purchase_code'];
                $purchase_source = $_POST['purchase_source'];
                $package_name    = $_POST['package_name'];
            } else {
                $errorMessage = "Operation failed: " . $stmt->error;
            }
            $stmt->close();
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>License Settings</title>
</head>
<body>
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">
            <?php require("../includes/sidebar.php"); ?>
            <div class="layout-page">
                <?php require("../includes/navbar.php"); ?>
                <div class="content-wrapper">
                    <div class="container-xxl flex-grow-1 container-p-y">
                        <h2>License Settings</h2>
                        <small>Activate ONCE carefully. Contact Support if you have issues.</small>

                        <?php if (!empty($successMessage)): ?>
                            <div class="alert alert-success"><?php echo $successMessage; ?></div>
                        <?php endif; ?>

                        <?php if (!empty($errorMessage)): ?>
                            <div class="alert alert-danger"><?php echo $errorMessage; ?></div>
                        <?php endif; ?>

                        <form method="POST">
                            <div class="mb-3">
                                <div class="mt-2 mb-4">
                                    <label for="largeSelect" class="form-label">Purchase Source</label>
                                    <select id="largeSelect" class="form-select form-select-lg" name="purchase_source">
                                        <option value="0"  <?php echo ($purchase_source == 0  ? 'selected' : ''); ?>>Select Source</option>
                                        <option value="1"  <?php echo ($purchase_source == 1  ? 'selected' : ''); ?>>BycomBazaar</option>
                                        <option value="2"  <?php echo ($purchase_source == 2  ? 'selected' : ''); ?>>CodeCanyon</option>
                                        <option value="3"  <?php echo ($purchase_source == 3  ? 'selected' : ''); ?>>Codester</option>
                                    </select>
                                </div>
                            </div>

                            <div class="mb-3">
                                <label for="purchaseCodeInput" class="form-label">Purchase Code</label>
                                <input id="purchaseCodeInput" name="purchase_code" class="form-control" type="text"
                                       placeholder="XXXXX-XXXXX-XXXXX-XXXXX" value="<?php echo htmlspecialchars($purchase_code); ?>" required>
                            </div>

                            <div class="mb-3">
                                <label for="packageNameInput" class="form-label">Package Name</label>
                                <input id="packageNameInput" name="package_name" class="form-control" type="text"
                                       placeholder="com.domain.app" value="<?php echo htmlspecialchars($package_name); ?>" 
                                       pattern="^[a-z][a-z0-9]*(\.[a-z][a-z0-9_]*)+$" required>
                            </div>

                            <button class="btn btn-primary" type="submit" name="save_data">Save Data</button>
                            <?php if ($show_activate_button): ?>
                                <button class="btn btn-secondary" type="submit" name="activate_license">Activate</button>
                            <?php endif; ?>
                        </form>

                        <input type="hidden" name="base_url" value="<?php echo $base_url; ?>">

                    </div>
                </div>
                <?php require("../includes/footer.php"); ?>
            </div>
        </div>
    </div>
</body>
</html>